/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import java.util.EnumMap;

import lombok.Getter;
import lombok.Setter;

/**
 * Represents an XML of Reported Transaction.
 */
@Getter
@Setter
public class XmlReportedTransaction {

    private boolean isRefund;
    private String transactionIdentifier;
    private String corrTransactionIdentifier;
    private XmlTypeAndValue amount;
    private String paymentMethodType;
    private Integer paymentMethodOtherId;
    private String pspRoleType;
    private Integer pspRoleOtherId;
    private boolean initiatedPhysical;
    private XmlTypeAndValue payerMs;
    private final EnumMap<TransactionDateEnum, XmlTransactionDate> dates = new EnumMap<>(TransactionDateEnum.class);
    private boolean isInErrorRtBr0080 = false;

    /**
     * Add date.
     *
     * @param transactionDateEnum the transaction date enum
     * @param date                the date
     */
    public void addDate(final TransactionDateEnum transactionDateEnum, final String date, String other) {
        final XmlTransactionDate result = this.dates.put(transactionDateEnum, new XmlTransactionDate(date, other));
        if (result != null) {
            this.isInErrorRtBr0080 = true;
        }
    }

    /**
     * Gets date.
     *
     * @param transactionDateEnum the transaction date enum
     * @return the date
     */
    public XmlTransactionDate getDate(final TransactionDateEnum transactionDateEnum) {
        return this.dates.get(transactionDateEnum);
    }
}
